package w83a.w83aUtilidades;



import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


import w83a.w83aBeans.W83aPaginacionBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aClsTrazas;
import w83a.w83aUtilidadesComunes.W83aUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaError;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

/**
 * The Class W83aUtilidadesComunes.
 *
 * @author
 */
public abstract class W83aUtilidadesComunes{
	
	
	/**
	 * Funcin para poder meter mensajes y poder verlos en la aplicacin.
	 *
	 * @param request the request
	 * @param messages the messages
	 * @param idioma the idioma
	 */
	public static void anyadirMensajeAplicacion(HttpServletRequest request, List messages,String idioma){
		ActionMessages aMessages = new ActionMessages();
		
		try {
		for(int i=0,fin = messages.size();i<fin;i++){
				aMessages.add("mensajesAplicacionnoError", 
						new ActionMessage( //NOPMD
								Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun",(String)messages.get(i),idioma)));
		}
		request.setAttribute(Globals.MESSAGE_KEY, aMessages);
		} catch (Q70GestorMensajesException e) {
		
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
	}
	
	/**
	 * Funcin para poder meter mensaje y poder verlo en la aplicacin.
	 *
	 * @param request the request
	 * @param message the message
	 * @param idioma the idioma
	 */
	public static void anyadirMensajeAplicacion(HttpServletRequest request, String message,String idioma){
		List listaMensajes = new ArrayList();
		listaMensajes.add(message);
		anyadirMensajeAplicacion(request,listaMensajes,idioma);		
	}
	
	/**
	 * Anyadir mensaje error aplicacion.
	 *
	 * @param errors the errors
	 * @param messageKey the message key
	 * @param idioma the idioma
	 */
	public static void anyadirMensajeErrorAplicacion(Q70OperacionInternaErrors errors,String messageKey,String idioma){
		
		try {
			errors.add("OI_ERROR", 
					new Q70OperacionInternaError(
							Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun",messageKey,idioma)));
		} catch (Q70GestorMensajesException e) {
	
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		
	}
	
	/**
	 * Anyadir mensaje error aplicacion.
	 *
	 * @param errors the errors
	 * @param messageKey the message key
	 * @param idioma the idioma
	 */
	public static void anyadirMensajeErrorAplicacion(ActionErrors errors,String messageKey,String idioma){
		
		try {
			errors.add("OI_ERROR", 
					new ActionError(
							Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun",messageKey,idioma)));
		} catch (Q70GestorMensajesException e) {
			
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		
	}
	
	/**
	 * funcin que carga el bean W83aPaginacionBean con los parmetros de RIA que vienes en la request.
	 *
	 * @param request the request
	 * @param bean the bean
	 * @return the object
	 * @throws JSONException the jSON exception
	 */
	public static Object inicializarPaginador(HttpServletRequest request, W83aPaginacionBean bean)throws JSONException{
		
		String pagina = request.getParameter(W83aClsConstantes.RIA_FILAS_PAGINA);
		boolean cambioPagina = false;
		boolean cambioPagina2 = false;
		if(StringUtils.isNotEmpty(bean.getTotal())&&!pagina.equals(bean.getTotal())){
			cambioPagina = true;
		}
		bean.setTotal(pagina);
		
		
		String paginaASaltar = request.getParameter(W83aClsConstantes.RIA_PAGINA_ACTUAL);
		if(StringUtils.isNotEmpty(bean.getPage())&&!paginaASaltar.equals(bean.getPage())){
			cambioPagina2 = true;
		}
		
		if(!cambioPagina){
			bean.setPage(request.getParameter(W83aClsConstantes.RIA_PAGINA_ACTUAL));
		}else{
			bean.setPage("1");			
		}
		bean.setIdColumna(request.getParameter(W83aClsConstantes.RIA_IDCOLUMNAORDENAR));
		bean.setSort(request.getParameter(W83aClsConstantes.RIA_DIRECCIONORDENACION));
		
		if(cambioPagina||cambioPagina2){
			bean.setCambioPagina(true);
		}else{
			bean.setCambioPagina(false);			
		}
		
		return bean;		
	}
	
	/**
	 * funcin que carga el bean W83aPaginacionBean con los parmetros de RIA que vienes en la request.
	 *
	 * @param request the request
	 * @param bean the bean
	 * @return the object
	 * @throws JSONException the jSON exception
	 */
	public static Object inicializarPaginadorPaginaUno(HttpServletRequest request, W83aPaginacionBean bean)throws JSONException{
		
		String pagina = request.getParameter(W83aClsConstantes.RIA_FILAS_PAGINA);
		boolean cambioPagina = false;
		boolean cambioPagina2 = false;
		if(StringUtils.isNotEmpty(bean.getTotal())&&!pagina.equals(bean.getTotal())){
			cambioPagina = true;
		}
		bean.setTotal(pagina);
		
		
		String paginaASaltar = request.getParameter(W83aClsConstantes.RIA_PAGINA_ACTUAL);
		if(StringUtils.isNotEmpty(bean.getPage())&&!paginaASaltar.equals(bean.getPage())){
			cambioPagina2 = true;
		}
		
			bean.setPage("1");	
			
		bean.setIdColumna(request.getParameter(W83aClsConstantes.RIA_IDCOLUMNAORDENAR));
		bean.setSort(request.getParameter(W83aClsConstantes.RIA_DIRECCIONORDENACION));
		
		if(cambioPagina||cambioPagina2){
			bean.setCambioPagina(true);
		}
		
		return bean;		
	}
	
	/**
	 * Func procesarTabla
	 * Recoge una lista de objetos y la convierte en un objeto jSon para que la pueda leer una tabla RIA y la pinte.
	 *
	 * @param listaObjetos -> todos los objetos devueltos por la BD.
	 * @param listaVariables -> lista de variables que se van a ver en la tabla, es decir, las variables que se
	 * corresponden con las columnas de la tabla RIA. Se puede poner variables que sean beans separadas por "."
	 * @param varIdentificativa -> variable que corresponde con el identificativo de la fila de la tabla.
	 * @param clase -> nombre del bean.
	 * @param paginacion -> W83aPaginacionBean con la informacin de paginacin de la tabla
	 * Palabras clave que se le van a meter al objeto jSon:
	 * --> "total": pginas totales. x si total es 25, en la tabla se ver 1 de 25
	 * --> "page": pgina actual
	 * --> "records": total de registros que se le pasan
	 * @return the string
	 * @throws JSONException the jSON exception
	 */
	public static String procesarTabla(List listaObjetos,List listaVariables,String varIdentificativa,Class clase, W83aPaginacionBean paginacion)throws JSONException{//NOPMD
		
		JSONObject raiz = new JSONObject();
		try{
			if("0".equals(paginacion.getRows())){
				paginacion.setRows("1");
			}
			
			if("".equals(paginacion.getPage())){
				paginacion.setPage("1");
			}
			if("".equals(paginacion.getTotal())){
				paginacion.setTotal("1");
			}
			raiz.put("total", paginacion.getRows());
			if(Integer.parseInt(paginacion.getRows())<Integer.parseInt(paginacion.getPage())){
				paginacion.setPage("1");
			}
			raiz.put("page", paginacion.getPage());
			int records = listaObjetos.size();
//			if(0==records){
//				records = 1;
//			}
			raiz.put("records",records);
			//raiz.put("actualRecords",listaObjetos.size());
			
			if(StringUtils.isNotEmpty(varIdentificativa)){
				varIdentificativa = varIdentificativa.substring(0,1).toUpperCase() + varIdentificativa.substring(1);
			}
	
			JSONArray rows = new JSONArray();
			JSONObject row;
			JSONArray cell;
			
			int primerNumIteracion = (Integer.parseInt(paginacion.getPage())-1)*Integer.parseInt(paginacion.getTotal());
			
			int tamanyoIteracion = Integer.parseInt(paginacion.getTotal()) * Integer.parseInt(paginacion.getPage());
			
			if((primerNumIteracion + Integer.parseInt(paginacion.getTotal()))>listaObjetos.size()){
				tamanyoIteracion = listaObjetos.size();
			}
			
			//DATOS
			if(tamanyoIteracion>0){
				for (int i = primerNumIteracion; i < tamanyoIteracion; i++) {
					Object bean =  listaObjetos.get(i);
					row = new JSONObject();//NOPMD
					if(StringUtils.isNotEmpty(varIdentificativa)){
						row.put("id", clase.getMethod("get"+varIdentificativa, null).invoke(bean, null).toString().replaceAll("/", "_"));
					}else{
						row.put("id", i);						
					}
						cell = new JSONArray();//NOPMD
						
						for (int j = 0; j < listaVariables.size(); j++) {
							String metodo = (String)listaVariables.get(j);

								String[] metodoLst = metodo.split("\\.");
								if(metodoLst.length==0){
									metodoLst = new String[1];//NOPMD
									metodoLst[0] = metodo;
								}
								Object objeto = bean;
								for(int k=0,size=metodoLst.length;k<size;k++){
									metodoLst[k] = metodoLst[k].substring(0,1).toUpperCase() + metodoLst[k].substring(1);//NOPMD
									objeto = objeto.getClass().getMethod("get"+metodoLst[k], null).invoke(objeto, null);
								}
								if("tratado".equals(metodo)){
									if("No".equals(objeto)){
										objeto = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='"+Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO_RIA")+"/images/botones/cancelar.png'/>";
									}else{
										objeto = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='"+Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO_RIA")+"/images/botones/drag-valido.png'/>";
									}
								}
								if("estado".equals(metodo)){
									if("1".equals(objeto)){
										objeto = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='"+Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO_RIA")+"/images/botones/drag-valido.png'/>";
									}else if("2".equals(objeto)){
										objeto = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src='"+Q70ListenerUtils.getApplicationResourceURI("PREFIJO_URL_ESTATICO","ALIAS_ESTATICO_RIA")+"/images/botones/cancelar.png'/>";
									}
								}
								cell.put(objeto);

							
						}
						
					row.put("cell", cell);
					rows.put(row);
				}
			}
			raiz.put("rows", rows);
		}catch (Exception e) {
		
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		return raiz.toString();
	}
	
	/**
	 * Func procesarTabla
	 * Recoge una lista de objetos y la convierte en un objeto jSon para que la pueda leer una tabla RIA y la pinte.
	 *
	 * @param listaObjetos -> todos los objetos devueltos por la BD.
	 * @param listaVariables -> lista de variables que se van a ver en la tabla, es decir, las variables que se
	 * corresponden con las columnas de la tabla RIA. Se puede poner variables que sean beans separadas por "."
	 * @param varIdentificativa -> variable que corresponde con el identificativo de la fila de la tabla.
	 * @param clase -> nombre del bean.
	 * @param paginacion -> W83aPaginacionBean con la informacin de paginacin de la tabla
	 * Palabras clave que se le van a meter al objeto jSon:
	 * --> "total": pginas totales. x si total es 25, en la tabla se ver 1 de 25
	 * --> "page": pgina actual
	 * --> "records": total de registros que se le pasan
	 * @return the string
	 * @throws JSONException the jSON exception
	 */
	public static String procesarTablaConId(List listaObjetos,List listaVariables,String varIdentificativa,Class clase, W83aPaginacionBean paginacion)throws JSONException{//NOPMD
		
		JSONObject raiz = new JSONObject();
		try{
			if("0".equals(paginacion.getRows())){
				paginacion.setRows("1");
			}
			
			if("".equals(paginacion.getPage())){
				paginacion.setPage("1");
			}
			if("".equals(paginacion.getTotal())){
				paginacion.setTotal("1");
			}
			raiz.put("total", paginacion.getRows());
			if(Integer.parseInt(paginacion.getRows())<Integer.parseInt(paginacion.getPage())){
				paginacion.setPage("1");
			}
			raiz.put("page", paginacion.getPage());
			int records = listaObjetos.size();
//			if(0==records){
//				records = 1;
//			}
			raiz.put("records",records);
			//raiz.put("actualRecords",listaObjetos.size());
			
			varIdentificativa = varIdentificativa.substring(0,1).toUpperCase() + varIdentificativa.substring(1);
	
			JSONArray rows = new JSONArray();
			JSONObject row;
			JSONArray cell;
			
			int primerNumIteracion = (Integer.parseInt(paginacion.getPage())-1)*Integer.parseInt(paginacion.getTotal());
			
			int tamanyoIteracion = Integer.parseInt(paginacion.getTotal()) * Integer.parseInt(paginacion.getPage());
			
			if((primerNumIteracion + Integer.parseInt(paginacion.getTotal()))>listaObjetos.size()){
				tamanyoIteracion = listaObjetos.size();
			}
			
			//DATOS
			if(tamanyoIteracion>0){
				for (int i = primerNumIteracion; i < tamanyoIteracion; i++) {
					Object bean =  listaObjetos.get(i);
					row = new JSONObject();//NOPMD
					cell = new JSONArray();//NOPMD
					row.put("id", clase.getMethod("get"+varIdentificativa, null).invoke(bean, null).toString().replaceAll("/", "_")+"_"+i);
						String metodo="";//NOPMD
						for (int j = 0; j < listaVariables.size(); j++) {
							metodo = (String)listaVariables.get(j);

								String[] metodoLst = metodo.split("\\.");
								if(metodoLst.length==0){
									metodoLst = new String[1];//NOPMD
									metodoLst[0] = metodo;
								}
								Object objeto = bean;
								for(int k=0,size=metodoLst.length;k<size;k++){
									metodoLst[k] = metodoLst[k].substring(0,1).toUpperCase() + metodoLst[k].substring(1);//NOPMD
									objeto = objeto.getClass().getMethod("get"+metodoLst[k], null).invoke(objeto, null);
								}
								cell.put(objeto);
//							}
							
						}
						
					row.put("cell", cell);
					rows.put(row);
				}
			}	
			raiz.put("rows", rows);
		}catch (Exception e) {
			
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		return raiz.toString();
	}
	
	/**
	 * Func procesarHasMap
	 * Recoge una lista de objetos y la convierte en un objeto jSon para que la pueda leer una tabla RIA y la pinte.
	 * OJO: ESTE MTODO ORDENA EL HASHMAP QUE LE LLEGA POR CLAVE
	 * 
	 * @param listaObjetos -> todos los objetos devueltos por la BD.
	 * @param listaVariables -> lista de variables que se van a ver en la tabla, es decir, las variables que se
	 * corresponden con las columnas de la tabla RIA. Se puede poner variables que sean beans separadas por "."
	 * @param varIdentificativa -> variable que corresponde con el identificativo de la fila de la tabla.
	 * @param clase -> nombre del bean.
	 * @param paginacion -> W83aPaginacionBean con la informacin de paginacin de la tabla
	 * Palabras clave que se le van a meter al objeto jSon:
	 * --> "total": pginas totales. x si total es 25, en la tabla se ver 1 de 25
	 * --> "page": pgina actual
	 * --> "records": total de registros que se le pasan
	 * @return the string
	 * @throws JSONException the jSON exception
	 */
	public static String procesarHashMap(HashMap listaObjetos,List listaVariables,String varIdentificativa,Class clase, W83aPaginacionBean paginacion)throws JSONException{//NOPMD
		
		Map mapOrdenado = new TreeMap(listaObjetos);

		
		JSONObject raiz = new JSONObject();
		try{
			if("0".equals(paginacion.getRows())){
				paginacion.setRows("1");
			}
			
			if("".equals(paginacion.getPage())){
				paginacion.setPage("1");
			}
			if("".equals(paginacion.getTotal())){
				paginacion.setTotal("1");
			}
			raiz.put("total", paginacion.getRows());
			raiz.put("page", paginacion.getPage());
			int records = mapOrdenado.size();
//			if(0==records){
//				records = 1;
//			}
			raiz.put("records",records);
			//raiz.put("actualRecords",listaObjetos.size());
			
			varIdentificativa = varIdentificativa.substring(0,1).toUpperCase() + varIdentificativa.substring(1);
	
			JSONArray rows = new JSONArray();
			JSONObject row;
			JSONArray cell;
			
			int primerNumIteracion = (Integer.parseInt(paginacion.getPage())-1)*Integer.parseInt(paginacion.getTotal());
			
			int tamanyoIteracion = Integer.parseInt(paginacion.getTotal()) * Integer.parseInt(paginacion.getPage());
			
			if((primerNumIteracion + Integer.parseInt(paginacion.getTotal()))>mapOrdenado.size()){
				tamanyoIteracion = mapOrdenado.size();
			}
			
			//DATOS
			if(tamanyoIteracion>0){
				Iterator itr = mapOrdenado.entrySet().iterator();
				int i = 0;
				while (itr.hasNext()) {
					Map.Entry e = (Map.Entry)itr.next();
					
					if(i>=primerNumIteracion&&i<tamanyoIteracion){
						
						Object bean=e.getValue();
						row = new JSONObject();//NOPMD
						row.put("id", clase.getMethod("get"+varIdentificativa, null).invoke(bean, null).toString().replaceAll("/", "_"));
							cell = new JSONArray();//NOPMD
							
							for (int j = 0; j < listaVariables.size(); j++) {
								String metodo = (String)listaVariables.get(j);
	
									String[] metodoLst = metodo.split("\\.");
									if(metodoLst.length==0){
										metodoLst = new String[1];//NOPMD
										metodoLst[0] = metodo;
									}
									Object objeto = bean;
									for(int k=0,size=metodoLst.length;k<size;k++){
										metodoLst[k] = metodoLst[k].substring(0,1).toUpperCase() + metodoLst[k].substring(1);//NOPMD
										objeto = objeto.getClass().getMethod("get"+metodoLst[k], null).invoke(objeto, null);
									}
									cell.put(objeto);
									
	//							}
								
							}
							
						row.put("cell", cell);
						rows.put(row);
					}else if(i>=tamanyoIteracion){
						break;
					}
					i++;
				}
			}	
			raiz.put("rows", rows);
		}catch (Exception e) {
			
			W83aClsTrazas.trazaError(null,e.getLocalizedMessage(),e);
		}
		return raiz.toString();
	}

	/**
	 * Fnc validar dni.
	 *
	 * @param str1 the str1
	 * @return true, if successful
	 */
	public static boolean fncValidarDni(String str1) {//NOPMD
		// TODO Auto-generated method stub
		str1 = str1.toUpperCase();
//valida de la forma 11111111H
		Pattern patron=Pattern.compile("\\d{3,8}[azA-Z]{1}");
//valida de la forma 11111111-H
//		Pattern patron=Pattern.compile("\\d{3,8}\\-[azA-Z]{1}");
		if(str1.length()==9){
			Matcher m=patron.matcher(str1);
			if( m.matches()){
				return( validarLetra(str1));
				
			}		
			return false;
		}else{
			return false;
		}
	}

	/**
	 * Validar letra.
	 *
	 * @param str1 the str1
	 * @return true, if successful
	 */
	private static boolean validarLetra(String str1) {

		String nif=str1.substring(0, 8);
		
		int letra=(Integer.valueOf(nif).intValue())%23;
		String[] abc={"T","R","W","A","G","M","Y","F","P","D","X","B","N","J","Z","S","Q","V","H","L","C","K","E","T"};
		 
		if(abc[letra].compareToIgnoreCase(str1.substring(8, 9))==0){
		return true;
		}
		return false;
	}

	/**
	 * Lista sindicatos.
	 *
	 * @param lista the lista
	 * @param elemento the elemento
	 * @return the list
	 */
	public static List listaSindicatos(List lista, String elemento){

		String[] valores=elemento.split("\\|");
		String[] sindicatos;
		int numdelegados;
		boolean encontrado=false;
		if (lista.isEmpty()){
			encontrado=true;
			lista.add(W83aUtilidadesComunes.rellenarCeros(valores[0])+"|"+valores[1]+"|"+valores[2]);
		}
		else{
			for (int i=0;i<lista.size();i++){
				sindicatos=((String)lista.get(i)).split("\\|");
				if (valores[2].equals(sindicatos[2])){
					numdelegados=Integer.parseInt(valores[0])+Integer.parseInt(sindicatos[0]);
					lista.set(i, W83aUtilidadesComunes.rellenarCeros(String.valueOf(numdelegados))+"|"+sindicatos[1]+"|"+sindicatos[2].trim());
					encontrado=true;
					break;
				}
			}
		}
		if (!encontrado){
			lista.add(W83aUtilidadesComunes.rellenarCeros(valores[0])+"|"+valores[1]+"|"+valores[2]);
		}
		return lista;
	}
	
	public static Map listaSindAgrupConv(Map sindicatosagrup, String sindicato, String numdelegados){
		String[] valores=sindicato.split("\\|");
		String[] valnumdel;
		if (sindicatosagrup.get(sindicato)!=null){
			valnumdel=String.valueOf(sindicatosagrup.get(sindicato)).split("\\|");
			sindicatosagrup.put(sindicato, rellenarCeros(String.valueOf(Integer.parseInt(valnumdel[0])+Integer.parseInt(numdelegados)))+"|"+valores[0]);//Aado +"|"+valores[0] para que luego se ordene bien en la funcin getSortedMap
		}
		else{
			sindicatosagrup.put(sindicato, rellenarCeros(numdelegados)+"|"+valores[0]);
		}
		return sindicatosagrup;
	}
	public static Map getSortedMap(Map hmap)
	{
		Map map = new LinkedHashMap();
		List mapKeys = new ArrayList(hmap.keySet());
		List mapValues = new ArrayList(hmap.values());
		hmap.clear();
		TreeSet sortedSet = new TreeSet(mapValues);
		Object[] sortedArray = sortedSet.toArray();
		int size = sortedArray.length;
		// De manera descendente
		for (int i=size-1; i>-1; i--)
		{
			//No se tienen en cuenta los duplicados, as que los values tienen que ser diferentes, por eso les he aadid al final el cdigo de sindicato..
			map.put(mapKeys.get(mapValues.indexOf(sortedArray[i])), sortedArray[i]);
		}
	return map;
	} 
	/**
	 * Fnc validar telefono.
	 *
	 * @param str1 the str1
	 * @return true, if successful
	 */
	public static boolean fncValidarTelefono(String str1) {
		
		if(str1.length()==9){
			return true;
		}
		return false;
		
	}
		
		/**
		 * obtenerTitulosDelegacionDepartamento.
		 *
		 * @param usuario the usuario
		 * @param idioma the idioma
		 * @return the hashmap
		 * @throws Q70GestorMensajesException the q70 gestor mensajes exception
		 */
	public static HashMap obtenerTitulosDelegacionDepartamento(
			W83aUsuarioXLNetsBean usuario, String idioma) throws Q70GestorMensajesException {
	    String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());        

        StringBuffer  tituloDelelegacionEu = new StringBuffer();
        StringBuffer  tituloDelelegacionEs = new StringBuffer();
        StringBuffer  tituloDelelegacionTextoEu = new StringBuffer();
        StringBuffer  tituloDelelegacionTextoEs = new StringBuffer();
        StringBuffer  tituloDepEu = new StringBuffer();
        StringBuffer  tituloDepEs = new StringBuffer();
        
        tituloDepEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_eu",idioma));      
        tituloDepEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.tituloImagenInforme_es",idioma));
        
        
        
        if(W83aClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.direccionTrabajo_es",idioma));
        	tituloDelelegacionTextoEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.trabajo_eu",idioma));
        	tituloDelelegacionTextoEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.trabajo_es",idioma));
        }else if(W83aClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma));
        	tituloDelelegacionTextoEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloDelelegacionTextoEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionAlava_es",idioma)).append(",");
        }else if(W83aClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        	tituloDelelegacionTextoEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloDelelegacionTextoEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionGuipuzcoa_es",idioma)).append(",");
        }else if(W83aClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloDelelegacionEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloDelelegacionEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma));
        	tituloDelelegacionTextoEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_eu",idioma));
        	tituloDelelegacionTextoEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.delegacionBizkaia_es",idioma)).append(",");
        }
        
        tituloDelelegacionTextoEu=new StringBuffer(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.departamento_eu",idioma).concat("(e)ko ").concat(tituloDelelegacionTextoEu.toString()));
    	tituloDelelegacionTextoEs.append(" del ").append(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.informes.departamento_es",idioma));
        HashMap resul=new HashMap();
        resul.put("tituloDelelegacionEu", tituloDelelegacionEu);
        resul.put("tituloDelelegacionEs", tituloDelelegacionEs);
        resul.put("tituloDelelegacionTextoEu", tituloDelelegacionTextoEu);
        resul.put("tituloDelelegacionTextoEs", tituloDelelegacionTextoEs);
        resul.put("tituloDepEu", tituloDepEu);
        resul.put("tituloDepEs", tituloDepEs);
        resul.put("dirdelegacion", usuario.getCalleListadosFormateada());
        resul.put("localiddelegacion", usuario.getLocalidadTxtCastDelegacionMin());
        return resul;
        
        
	}
	
	public static StringBuffer obtenerCalledelegacionFormateada(W83aUsuarioXLNetsBean usuario) throws Q70GestorMensajesException {
		StringBuffer calleformateada=new StringBuffer(W83aClsConstantes.VEINTE);
		if(StringUtils.isNotEmpty(usuario.getCalleDelegacion())){
			calleformateada.append(usuario.getCalleDelegacion());
		}
		if(StringUtils.isNotEmpty(usuario.getNumeroDelegacion())){
			calleformateada.append(" n");
			calleformateada.append(usuario.getNumeroDelegacion());
		}
		if(StringUtils.isNotEmpty(usuario.getPisoDelegacion())){
			calleformateada.append(" ");
			calleformateada.append(usuario.getPisoDelegacion());
			calleformateada.append("");
		}
        return calleformateada;
        
        
	}
		
/*	public static W83aDocBean obtenerInformacionDocumento(
			W83aComunicacionesBean comunic, StringBuffer datosind, String texto, String fase, String tramite, String tipo){
		
		W83aDocBean docBean= new W83aDocBean();//NOPMD
		docBean.setNumActaTerritorio(comunic.getTerrit());
		if ("preaviso".equals(tipo)){
			docBean.setNumActaAno(comunic.getAnopreaviso());
			docBean.setNumActa(comunic.getNpre());
		}
		else{
			docBean.setNumActaAno(comunic.getAnoacta());
			docBean.setNumActa(comunic.getNacta());
		}
		docBean.setCodTramite(tramite);
		docBean.setCodFase(fase);
		docBean.setNombre(texto);
		docBean.setFechaRegistro(comunic.getFechaaregistro());
		docBean.setUsuario(comunic.getUsuarioBean().getIdUsuario());
		docBean.setNumeroRegistro(comunic.getNumsalida());
		byte[] bytes = datosind.toString().getBytes();
		InputStream input=new ByteArrayInputStream(bytes);//NOPMD
		docBean.setFileData(input);
	
		docBean.setTamanyo(datosind.toString().getBytes().length);
		docBean.setEscomunicacion(comunic.getEscomunicacion());
		return docBean;
		
	}*/
		
	
		/**
		 * Rellenar ceros.
		 *
		 * @param pNumero the numero
		 * @return the string
		 */
	public static String rellenarCeros(String pNumero) {
		StringBuffer num = new StringBuffer();//NOPMD
		
		if (pNumero.length()==1){
			num.append("00000").append(pNumero);
		}else if (pNumero.length()==2){
			num.append("0000").append(pNumero);
		}else if (pNumero.length()==3){
			num.append("000").append(pNumero);
		}else if (pNumero.length()==4){
			num.append("00").append(pNumero);
		}else if (pNumero.length()==5){
			num.append("0").append(pNumero);
		}else{
			num.append(pNumero);
		}
		return num.toString();
	}
	
	/**
	 * Rellenar cabecera.
	 *
	 * @param pProperties the properties
	 * @param pEtiqueta the etiqueta
	 * @return the string
	 * @throws Exception the exception
	 */
	public static String rellenarCabecera(String pProperties, String pEtiqueta) throws Exception{
		String obtCast= W83aClsConstantes.CONSTANTE_CASTELLANO;
        String obtEusk= W83aClsConstantes.CONSTANTE_EUSKARA;
		StringBuffer cabecera = new StringBuffer();
		cabecera.append(Q70GestorMensajesi18n.getSingleton().getMessage(pProperties,pEtiqueta,obtEusk));
		cabecera.append(" / ");
		cabecera.append(Q70GestorMensajesi18n.getSingleton().getMessage(pProperties,pEtiqueta,obtCast));
		return cabecera.toString();
	}
	
	
	
	
}